# Financhile

## Overview

Financhile is a static marketing website for a Chilean financial advisory company. The site presents the company's financial consulting services, pricing plans, team information, and contact details. It's built as a simple multi-page static website targeting Spanish-speaking clients in Chile who need personal finance guidance and investment advice.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
- **Pure HTML/CSS/JavaScript**: No frameworks or build tools. Each page is a standalone HTML file with shared CSS styling.
- **Multi-page structure**: Seven main content pages (index, servicios, planes, nosotros, contacto) plus four legal pages (privacy policy, terms, cookies, data treatment).
- **CSS Custom Properties**: Uses CSS variables for consistent theming with a black and gold color scheme.
- **Fixed Navigation**: Consistent navbar across all pages with active state highlighting.

### Design Patterns
- **Component-based CSS**: Reusable card components (`.feature-card`, `.servicio-card`, `.plan-card`, `.valor-card`) for consistent content presentation.
- **Container pattern**: Max-width container with auto margins for centered, responsive content.
- **BEM-like naming**: CSS classes follow descriptive naming conventions.

### JavaScript Functionality
- **Cookie consent management**: Simple localStorage-based cookie banner acceptance/rejection system.
- **No external dependencies**: Vanilla JavaScript only.

### Asset Structure
- Images expected in `assets/images/` directory (referenced but not present in repository).
- Single shared stylesheet (`styles.css`) for all pages.
- Single JavaScript file (`script.js`) for cookie functionality.

## External Dependencies

### Third-party Integrations
- **Google Maps Embed**: Contact page includes an embedded Google Maps iframe for office location display.

### No Backend Services
- This is a purely static site with no server-side processing, database, or API integrations.
- Contact form submissions would need to be connected to an external service (not currently implemented).

### Hosting Requirements
- Can be served from any static file hosting (no special server requirements).
- No build step needed - files are served as-is.